package com.tongyi.videochatdemo;

import android.app.Activity;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;

import com.tongyi.videochatdemo.databinding.PopupWindowTyBinding;

/**
 * @author flyingfish
 * date 2025/12/2
 * description SurfaceView设置透明背景时，会遮挡其他View，此处使用PopupWindow规避遮挡
 */
public class TYPopupWindow extends PopupWindow {
    public PopupWindowTyBinding binding;

    public TYPopupWindow(Activity activity) {
        super(activity);
        binding = PopupWindowTyBinding.inflate(activity.getLayoutInflater());
        View rootView = binding.getRoot();
        setContentView(rootView);
        setOutsideTouchable(false);
        setFocusable(false);
        setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
    }

    public void show(View view) {
        setWidth(ViewGroup.LayoutParams.MATCH_PARENT);
        setHeight(ViewGroup.LayoutParams.MATCH_PARENT);
        showAtLocation(view, Gravity.CENTER, 0, 0);
    }
}
