package com.tongyi.videochatdemo.util;

// 导入所需模块

import android.app.ProgressDialog;
import android.content.Context;

public class LoadingBox {

    private ProgressDialog progressDialog;

    public void showLoadingBox(Context context, String message) {
        showLoadingBox(context, message, false);
    }

    public void showLoadingBox(Context context, String message, boolean cancelable) {
        if (null == progressDialog) {
            progressDialog = new ProgressDialog(context);
            progressDialog.setCancelable(cancelable);
        }

        progressDialog.setMessage(message);
        if (!progressDialog.isShowing()) {
            progressDialog.show();
        }
    }

    public void setLoadingMessage(String message) {
        if (null != progressDialog) {
            progressDialog.setMessage(message);
        }
    }

    public void closeLoadingBox() {
        if (progressDialog != null) {
            progressDialog.dismiss();
        }
    }
}
