//
//  ALYDateFormatter.swift
//  TongyiApp
//
//  Created by George Mo on 2023/10/17.
//  Copyright © 2023 Aliyun. All rights reserved.
//

import Foundation

class ALYDateFormatter {
    
    static let dateFormatter = DateFormatter()
    
    
    /// 通用时间格式化方法
    /// - Parameters:
    ///   - time: 时间戳
    ///   - format: 格式表达式，例如 "yyyy-MM-ddTHH:mm:ss"
    /// - Returns: 格式
    static func format(time: TimeInterval, as format: String) -> String {
        dateFormatter.dateFormat = format
        // 设置为中文区域，确保获取的时间日期都是中文（如星期几）
        dateFormatter.locale = Locale(identifier: "zh_CN")
        return dateFormatter.string(from: Date(timeIntervalSince1970: time))
    }
    
    
    /// 把数字（秒）格式化成 00:00
    /// - Parameter time: 秒数
    /// - Returns: 00:00
    static func formatMinSec(time: TimeInterval) -> String {
        self.format(time: time, as: "mm:ss")
    }
    
    
    /// 把数字（秒）格式化成 00:00:00
    /// - Parameter time: 秒数
    /// - Returns: 大于一小时 00:00:00，小于一小时 00:00
    static func formatHourMinSec(time: Int, hideZeroHour: Bool = true) -> String {
        let hours = time / 3600
        let minutes = (time % 3600) / 60
        let seconds = time % 60
        // 格式化小时数
        let hoursStr = String(format: "%02d", hours)
        // 格式化分钟数
        let minutesStr = String(format: "%02d", minutes)
        // 格式化秒数
        let secondsStr = String(format: "%02d", seconds)

        // 如果小时数为0，则不显示小时部分
        if hideZeroHour, hours == 0 {
            return "\(minutesStr):\(secondsStr)"
        } else {
            // 否则显示小时:分钟:秒
            return "\(hoursStr):\(minutesStr):\(secondsStr)"
        }
    }
}

