//
//  TYWebController.swift
//  videochat_ios_demo
//
//  Created by wsy on 2025/7/7.
//

import UIKit
import videochat_ios_sdk
import Network

class TYWebController : UIViewController {
  
    private var isAlive : Bool = true
    private var mode : TYVoiceChatMode = .tap2talk
    var bgImgV : UIImageView = {
        let bgImg = UIImageView.init()
        bgImg.image = .init(named: "bg_main")
        bgImg.isUserInteractionEnabled = true
        return bgImg
    }()
    
    var titleLab : UILabel = {
        let titleLab = UILabel.init()
        titleLab.font = .boldSystemFont(ofSize: 18)
        titleLab.textAlignment = .center
        titleLab.textColor = .black
        titleLab.text = "iOS交互数字人 --云推流"
        return titleLab
    }()
    
    var talkSegment : CustomSegmentedControl = {
        let segControl = CustomSegmentedControl.init(items: ["push2talk","tap2talk","双工"])
        segControl.selectedSegmentIndex = 1
        segControl.setEnabled(false, forSegmentAt: 0)
        // segControl.setEnabled(false, forSegmentAt: 2)
        return segControl
    }()
    
    var cloudSegment : CustomSegmentedControl = {
        let segControl = CustomSegmentedControl.init(items: ["云端渲染","端侧渲染"])
        segControl.selectedSegmentIndex = 0
        segControl.setEnabled(false, forSegmentAt: 1)
        return segControl
    }()
    
    var aliveSegment : CustomSegmentedControl = {
        let segControl = CustomSegmentedControl.init(items: ["持续心跳保活开启","持续心跳保活关闭"])
        segControl.selectedSegmentIndex = 0
        return segControl
    }()
    
    var textV : UITextView = {
        let textView = UITextView.init()
        textView.backgroundColor = .white
        textView.layer.masksToBounds = true
        textView.layer.cornerRadius = 8
        textView.font = .systemFont(ofSize: 14)
        textView.textColor = .black
        return textView
    }()
    
    var placeLab : UILabel = {
        let placeLab = UILabel.init()
        placeLab.textColor = .gray
        placeLab.font = .systemFont(ofSize: 14)
        placeLab.text = "请输入RTC入会信息"
        return placeLab
    }()
    
    
   var testBtn : UIButton = {
        let btn = UIButton()
        btn.layer.masksToBounds = true
        btn.layer.cornerRadius = 8
        btn.setTitle("开始测试", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        return btn
    }()
    private var gradientLayer: CAGradientLayer?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .lightGray
        self.view.addSubview(self.bgImgV)
        self.bgImgV.addSubview(self.titleLab)
        self.bgImgV.addSubview(self.talkSegment)
        self.bgImgV.addSubview(self.cloudSegment)
        self.bgImgV.addSubview(self.aliveSegment)
        self.textV.addSubview(self.placeLab)
        self.bgImgV.addSubview(self.textV)
        self.bgImgV.addSubview(self.testBtn)
        
        self.bgImgV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        self.titleLab.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(self.view.safeAreaLayoutGuide.snp.top).inset(25)
            make.height.equalTo(40)
        }
        
        self.talkSegment.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(titleLab.snp.bottom).offset(25)
            make.width.equalTo(250)
            make.height.equalTo(40)
        }
        
        self.cloudSegment.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(talkSegment.snp.bottom).offset(25)
            make.width.equalTo(200)
            make.height.equalTo(40)
        }
        
        self.aliveSegment.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(cloudSegment.snp.bottom).offset(25)
            make.width.equalTo(300)
            make.height.equalTo(40)
        }
        
        self.textV.snp.makeConstraints { make in
            make.top.equalTo(self.aliveSegment.snp.bottom).offset(25)
            make.leftMargin.equalTo(15)
            make.rightMargin.equalTo(-15)
            make.height.equalTo(350)
        }
        self.placeLab.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(10)
            make.top.equalToSuperview().offset(6)
            make.height.equalTo(20)
        }
        
        self.testBtn.snp.makeConstraints { make in
            make.leftMargin.equalToSuperview().offset(30)
            make.rightMargin.equalToSuperview().offset(-30)
            make.bottomMargin.equalToSuperview().offset(-50)
            make.height.equalTo(50)
        }
        setupGradient()
        textV.delegate = self
        testBtn.addTarget(self, action:#selector(testBtnAction(sender:)) , for: .touchUpInside)
        aliveSegment.addTarget(self, action: #selector(segmentChanged(_:)), for: .valueChanged)
        talkSegment.addTarget(self, action: #selector(talkModeChanged(_:)), for: .valueChanged)
        let tap = UITapGestureRecognizer(target: self, action: #selector(bgImgTapAction(_:)))
        self.bgImgV.addGestureRecognizer(tap)
        videoChatTestAuthentication()
    }
    
    private func setupGradient() {
           let gradient = CAGradientLayer()
           gradient.colors = [
            UIColor.aly_fromHex(0x49419E).cgColor,
            UIColor.aly_fromHex(0x5E3579).cgColor
           ]
           gradient.startPoint = CGPoint(x: 0, y: 0.5)
           gradient.endPoint = CGPoint(x: 1, y: 0.5)
           gradient.cornerRadius = self.testBtn.layer.cornerRadius
           self.testBtn.layer.insertSublayer(gradient, at: 0)
           self.gradientLayer = gradient
       }
    
    override func viewDidLayoutSubviews() {
            super.viewDidLayoutSubviews()
        gradientLayer?.frame = testBtn.bounds
    }
    
    @objc func segmentChanged(_ sender: UISegmentedControl) {
        let index = sender.selectedSegmentIndex
//        sender.updateSelectedSegmentStyle()
        self.isAlive = index == 0 ? true : false
    }
    
    @objc func talkModeChanged(_ sender: UISegmentedControl) {
        let index = sender.selectedSegmentIndex
        self.mode = (index == 0) ? .push2talk : (index == 1) ? .tap2talk : .duplex
    }
    
    @objc func bgImgTapAction(_ sender:UITapGestureRecognizer) -> Void {
        if self.textV.isFirstResponder {
            self.textV.resignFirstResponder()
            if textV.text.isEmpty {
                self.placeLab.isHidden = false
            }else{
                self.placeLab.isHidden = true
            }
        }
    }
    //检查网络状态，触发网络权限弹窗
    func videoChatTestAuthentication(){
        let monitor = NWPathMonitor()
        monitor.pathUpdateHandler = { path in
            if path.status == .satisfied {
               
            } else {
               
            }
        }
        monitor.start(queue: DispatchQueue.global())
    }
    
    @objc func testBtnAction(sender: UIButton){
//        let tempJson = "{\"requestId\":\"generateRandomRequestId\",\"code\":\"200\",\"message\":null,\"success\":true,\"httpStatusCode\":200,\"rtcParams\":{\"gslb\":\"https://gw.rtn.aliyuncs.com\",\"appId\":\"470552b0-9401-4b2c-8456-df39f2e5a986\",\"channel\":\"1370415444023861\",\"nonce\":\"\",\"timestamp\":1752137226,\"token\":\"0a4288439356e51fcf3d7121a30a2a4342e6ef0d934858a64e88ed1f29f80e29\",\"clientUserId\":\"client-5860542647207499\",\"serverUserId\":\"system-1451558621131107\",\"avatarUserId\":\"avatar-8910799327180878\"},\"avatarAssets\":null,\"requiredLibs\":null}"
//        textV.text = tempJson
        if !textV.text.isEmpty {
            self.placeLab.isHidden = true
            let jsonStr = textV.text
            guard let data = jsonStr?.data(using: .utf8) else {
                ALYToast.shared.showToast(text:"鉴权字段有误，请修正后重新加入", style: .error)
                return
            }
            if let resp = try? JSONSerialization.jsonObject(with: data, options: .fragmentsAllowed) as? [String: Any] {
//                let requestId = "testUserId_\(Date().timeIntervalSince1970)"
                let params = TYDialogConfig(renderType:.cloud , mode: self.mode, keepAlive: self.isAlive, keepAlivePeriod: 10, avatarAudioFormat: "s16", outboundSampleRate: 48000)
                guard
                    let rtcParams = resp["rtcParams"] as? [String: Any],
                    let avatarUserId = rtcParams["avatarUserId"] as? String,
                    let appId = rtcParams["appId"] as? String,
                    let channel = rtcParams["channel"] as? String,
                    let clientUserId = rtcParams["clientUserId"] as? String,
                    let timestamp = rtcParams["timestamp"] as? Int64,
                    let token = rtcParams["token"] as? String,
                    let serverUserId = rtcParams["serverUserId"] as? String
                else{
                    print("[RTC] demo error")
                    return
                }
                let tempStr = resp["requestId"] as? String
                var requestId : String?
                if ((tempStr?.isEmpty) != nil) {
                    requestId = "testUserId_\(Date().timeIntervalSince1970)"
                }else{
                    requestId = tempStr
                }
                let avatarInitConfig = TYAvatarInitConfig.init(appId: appId, channel: channel, timestamp: timestamp, token: token, clientUserId: clientUserId, serverUserId: serverUserId, avatarUserId: avatarUserId)
                
                var assetConfig : TYAvatarAssetConfig?
                
                if  let assertParms:[String:String] = resp["avatarAssets"] as? [String : String] {
                    assetConfig = TYAvatarAssetConfig.init(url: assertParms["url"]!, md5: assertParms["md5"]!, secret: assertParms["secret"]!)}
                
                let avatarInitData = TYAvatarInitData(rtcParams: avatarInitConfig, avatarAssets: assetConfig, sessionId: resp["sessionId"] as? String)
                DispatchQueue.main.async {
                    let vc = VideoChatViewController(license: "", avatarInitData: avatarInitData, dialogConfig: params)
                    self.navigationController?.pushViewController(vc, animated: true)
                }
            }else{
                ALYToast.shared.showToast(text:"鉴权字段无法解析，请修正后重新加入", style: .error)
                return
            }
        }else{
            self.placeLab.isHidden = false
            ALYToast.shared.showToast(text:"鉴权字段为空，请粘贴后重新加入", style: .error)
            return
        }
    }
}


extension TYWebController : UITextViewDelegate {
    
    func textViewDidChange(_ textView: UITextView) {
        if textView.text.isEmpty {
            self.placeLab.isHidden = false
        }else{
            self.placeLab.isHidden = true
        }
    }
    
    func textViewDidBeginEditing(_ textView: UITextView) {
        self.placeLab.isHidden = true
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
        if textView.text.isEmpty {
            self.placeLab.isHidden = true
        }else{
            self.placeLab.isHidden = false
        }
    }
}
