//
//  TYPermission.swift
//  TYPermission
//
//  Created by Jeremy on 2023/12/1.
//

import UIKit
import Photos

/// 权限类型
@objc enum TYPermissionKind: Int {
    case microphone = 0
}

/// 权限状态
@objc enum TYPermissionStatus: Int {
    case notDetermined = 0
    case authorized
    case denied
}


/// 权限管理
@objc class TYPermission: NSObject {
    
    private let permission: TYPermissionInterface
    @objc init(kind: TYPermissionKind) {
        switch kind {
        case .microphone:
            self.permission = TYPermissionMicrophone()
        }
    }
    
    /// 权限状态
    var status: TYPermissionStatus {
        return self.permission.status
    }
    
    /// 请求权限
    /// - Parameter сompletionHandler: 请求完成的权限
    func request(with сompletionHandler: (()->())?) {
        self.permission.request(with: сompletionHandler)
    }
}
