//
//  UIButton+ALYExt.swift
//  ALYUIKit
//
//  Created by Wien on 2023/9/10.
//  Copyright © 2023 Aliyun. All rights reserved.
//

import UIKit

extension UIButton {
    
    private struct AssociatedKeys {
        static var hitEdgeInsets = "hitEdgeInsets"
    }
    
    public var aly_hitEdgeInsets: UIEdgeInsets {
        set {
            let value = NSValue(uiEdgeInsets: newValue)
            objc_setAssociatedObject(self, &AssociatedKeys.hitEdgeInsets, value, .OBJC_ASSOCIATION_RETAIN_NONATOMIC)
        }
        get {
            var insets = UIEdgeInsets.zero
            if let value = objc_getAssociatedObject(self, &AssociatedKeys.hitEdgeInsets) as? NSValue {
                insets = value.uiEdgeInsetsValue
            }
            return insets
        }
    }
    
    override public func point(inside point: CGPoint, with event: UIEvent?) -> Bool {
        if self.aly_hitEdgeInsets == .zero || !self.isEnabled || self.isHidden {
            return super.point(inside: point, with: event)
        }
        
        let hitFrame = self.bounds.inset(by: self.aly_hitEdgeInsets)
        return hitFrame.contains(point)
    }
    
}

// 处理图片和文字的位置以及间距
extension UIButton {
    enum ALYButtonImageStyle {
        case left       //图片在左，文字在右，整体居中
        case right      //图片在右，文字在左，整体居中
        case top        //图片在上，文字在下，整体居中
        case bottom     //图片在下，文字在上，整体居中
    }

    func aly_layoutButtonImage(style: ALYButtonImageStyle = .left, space:CGFloat = 5) {
        let imageRect: CGRect = self.imageView?.frame ?? CGRect.init()
        let titleRect: CGRect = self.titleLabel?.frame ?? CGRect.init()
        let selfWidth: CGFloat = self.frame.size.width
        let selfHeight: CGFloat = self.frame.size.height
        let totalHeight = titleRect.size.height + space + imageRect.size.height
        switch style {
        case .left:
            self.titleEdgeInsets = UIEdgeInsets(top: 0, left: space / 2, bottom: 0, right: -space / 2)
            self.imageEdgeInsets = UIEdgeInsets(top: 0, left: -space / 2, bottom: 0, right: space / 2)
        case .right:
            self.titleEdgeInsets = UIEdgeInsets(top: 0, left: -(imageRect.size.width + space/2), bottom: 0, right: (imageRect.size.width + space/2))
            self.imageEdgeInsets = UIEdgeInsets(top: 0, left: (titleRect.size.width + space / 2), bottom: 0, right: -(titleRect.size.width +  space/2))
        case .top :
            self.titleEdgeInsets = UIEdgeInsets(top: ((selfHeight - totalHeight) / 2 + imageRect.size.height + space - titleRect.origin.y), left: (selfWidth / 2 - titleRect.origin.x - titleRect.size.width / 2) - (selfWidth - titleRect.size.width) / 2, bottom: -((selfHeight - totalHeight) / 2 + imageRect.size.height + space - titleRect.origin.y), right: -(selfWidth / 2 - titleRect.origin.x - titleRect.size.width / 2) - (selfWidth - titleRect.size.width) / 2)
            self.imageEdgeInsets = UIEdgeInsets(top: ((selfHeight - totalHeight) / 2 - imageRect.origin.y), left: (selfWidth / 2 - imageRect.origin.x - imageRect.size.width / 2), bottom: -((selfHeight - totalHeight) / 2 - imageRect.origin.y), right: -(selfWidth / 2 - imageRect.origin.x - imageRect.size.width / 2))
        case .bottom:
            self.titleEdgeInsets = UIEdgeInsets(top: ((selfHeight - totalHeight) / 2 - titleRect.origin.y), left: (selfWidth / 2 - titleRect.origin.x - titleRect.size.width / 2) - (selfWidth - titleRect.size.width) / 2, bottom: -((selfHeight - totalHeight) / 2 - titleRect.origin.y), right: -(selfWidth/2 - titleRect.origin.x - titleRect.size.width / 2) - (selfWidth - titleRect.size.width) / 2)
            self.imageEdgeInsets = UIEdgeInsets(top: ((selfHeight - totalHeight) / 2 + titleRect.size.height + space - imageRect.origin.y), left: (selfWidth / 2 - imageRect.origin.x - imageRect.size.width / 2), bottom: -((selfHeight - totalHeight) / 2 + titleRect.size.height + space - imageRect.origin.y), right: -(selfWidth / 2 - imageRect.origin.x - imageRect.size.width / 2))
        }
    }
}
