//
//  DetectionResult.h
//  digital_human_ios_sdk
//
//  Created by George Mo on 2024/10/16.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TYDigitalResult : NSObject

@property (assign, nonatomic) long requestId;
/// 图片数据
@property (strong, nonatomic, nullable) NSData *frameData;
/// 图片数据指针
@property (assign, nonatomic, nullable) UInt8 *frameDataRef;

@property (assign, nonatomic) float videoPTS; //单位:us毫秒
@property (assign, nonatomic) float videoFPS; //实时帧率

/// 音频数据
@property (assign, nonatomic, nullable) UInt8 *audioDataRef;
@property (strong, nonatomic, nullable) NSData *audioData;
@property (assign, nonatomic) float audioPTS; //单位:us毫秒
@property (assign, nonatomic) long remainAudioSize; //剩余音频量：bytes

@property (assign, nonatomic) BOOL isSilence; //是否静音idle状态

@property (assign, nonatomic) int format;

@property (assign, nonatomic) long frameId;

@property (assign, nonatomic) long avatarStatus;

@property (assign, nonatomic) long sequenceId;

@end

NS_ASSUME_NONNULL_END
