//
//  TYFaceController.h
//  digital_human_ios_sdk
//
//  Created by George Mo on 2024/10/15.
//

#import <Foundation/Foundation.h>
#import <digital_human_ios_sdk/TYAudioRequest.h>
#import <digital_human_ios_sdk/TYProfileResult.h>
#import <digital_human_ios_sdk/TYDigitalResult.h>
#import <digital_human_ios_sdk/TYPreAudioData.h>

NS_ASSUME_NONNULL_BEGIN

typedef void (^ResultCallback)(TYDigitalResult *result);
static ResultCallback digitalResultCallback;

@interface TYFaceController : NSObject


- (instancetype)initWithMockResultFramesDir:(NSString * _Nullable )mockResultFramesDir;

- (instancetype)initWithJsonConfig:(NSString * _Nullable)config sampleRate:(NSInteger)sampleRate;

- (BOOL)stopTalking;

- (void)exit;

/// 端云结合版本，推送音频+BS到Cpp，进行二阶段推理
/// - Parameters:
///   - request: 算法请求参数
- (void)putImageAsync:(TYAudioRequest*)request;

/// 纯端版本，推送音频到Cpp，进行一阶段+二阶段推理
///
///
- (void)putPreAudioAsync:(TYPreAudioData*)request;

/// Mock算法推理结果
/// - Parameters:
///   - request: 算法请求参数
///   - testCount: 测试总图片数量，传-1表示无限大
- (void)putImageAsyncMock:(TYAudioRequest*)request testCount:(int)testCount;


/// 获取当前性能profile数据
- (NSDictionary<NSString*, NSNumber*> *)getPerformanceProfile;

/// 获取性能profile数据总数统计
- (NSDictionary<NSString*, NSNumber*> *)getTotalPerformanceProfile;


/// 注册算法检测结果回调
/// - Parameter callback: 回调
- (int)RegisterOnDetectionResultCallback:(void (^)(TYDigitalResult *result))callback;

/// 设置debug模式
- (void)setIsDebug:(BOOL)isDebug;

@end

NS_ASSUME_NONNULL_END
