
#import <UIKit/UIKit.h>

// 渲染画面填充模式。
typedef NS_ENUM(NSInteger, MetalViewContentMode) {
    // 自动填充满，可能会变形。
    MetalViewContentModeStretch = 0,
    // 按比例适配，可能会有黑边。
    MetalViewContentModeFitCenter = 1,
    // 根据比例裁剪后填充满。
    MetalViewContentModeCropCenter = 2
};
@interface TYMetalView : UIView

- (instancetype)initWithFrame:(CGRect)frame renderSize:(CGSize)size frontTextureRect:(CGRect)rect fillModel:(MetalViewContentMode)fillModel;

- (void)renderWithUInt8:(UInt8*)mat_uint8 :(UInt8*)maskMat_uint8 :(UInt8*)bfgMat_uint8 :(UInt8*)bbgMat_unit8 :(int)width :(int)height;
- (void)renderWithMatUInt8:(UInt8*)mat_uint8 :(int)width :(int)height;

// new API
- (void)renderWithUInt8:(UInt8*)mat_uint8 bgMat_uint8:(UInt8*)bbgMat_uint8 width:(int)width height:(int)height box:(CGRect)box;

- (void)enableChromaKey:(bool) enableChromaKey;

- (void)bgColor:(UIColor *)bgColor;

- (void)bgImage:(UIImage *)bgImage;

-(void)enableDrawFrame:(bool)enableDrawFrame;

@end


