//
//  CustomSegmentedControl.swift
//  videochat_ios_demo
//
//  Created by wsy on 2025/9/9.
//
import UIKit

class CustomSegmentedControl: UISegmentedControl {
    override init(items: [Any]?) {
        super.init(items: items)
        setup()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setup()
    }
    
    private func setup() {
        // 基础配置
        backgroundColor = UIColor(white:0.8, alpha: 0.9)
        layer.cornerRadius = 8
        layer.masksToBounds = true
        // 隐藏系统默认样式
        setBackgroundImage(UIImage(), for: .normal, barMetrics: .default)
        setDividerImage(UIImage(), forLeftSegmentState: .normal, rightSegmentState: .normal, barMetrics: .default)
        setTitleTextAttributes(
                     [.foregroundColor: UIColor.darkGray],
                     for: .normal
                 )
        setTitleTextAttributes(
                     [.foregroundColor: UIColor.aly_fromHex(0x3F51B5)],
                     for: .selected
                 )
        // 事件监听
        addTarget(self, action: #selector(segmentChanged), for: .valueChanged)
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        hideSystemSelectionIndicator()
        updateCustomSelectionStyle()
    }
    
    @objc private func segmentChanged() {
        updateCustomSelectionStyle()
    }
}

extension UISegmentedControl {
    // 隐藏系统默认的选中背景
    func hideSystemSelectionIndicator() {
        if let selectionView = subviews.first(where: { String(describing: type(of: $0)).contains("SelectionView") }) {
            selectionView.isHidden = true
            selectionView.layer.opacity = 0 // 双重保险
        }
    }
    
    func updateCustomSelectionStyle() {
           // 移除旧的自定义边框
           layer.sublayers?.removeAll(where: { $0.name == "customSelectionLayer" })
           guard numberOfSegments > 0, selectedSegmentIndex != UISegmentedControl.noSegment else { return }
           // 计算选中项的位置
           let segmentWidth = bounds.width / CGFloat(numberOfSegments)
           let xPosition = segmentWidth * CGFloat(selectedSegmentIndex)
           // 创建自定义选中层
           let selectionLayer = CALayer()
           selectionLayer.name = "customSelectionLayer"
           selectionLayer.frame = CGRect(x: xPosition, y: 0, width: segmentWidth, height: bounds.height)
           selectionLayer.backgroundColor = UIColor(red: 0.85, green: 0.92, blue: 1.0, alpha: 1.0).cgColor
           selectionLayer.borderColor = UIColor.aly_fromHex(0x3F51B5).cgColor
           selectionLayer.borderWidth = 1.0
           // 动态圆角逻辑
           let cornerRadius: CGFloat = 8
           var corners: CACornerMask = []
           
           if selectedSegmentIndex == 0 {
               corners.formUnion([.layerMinXMinYCorner, .layerMinXMaxYCorner])
           }
           if selectedSegmentIndex == numberOfSegments - 1 {
               corners.formUnion([.layerMaxXMinYCorner, .layerMaxXMaxYCorner])
           }
           selectionLayer.cornerRadius = corners.isEmpty ? 0 : cornerRadius
           selectionLayer.maskedCorners = corners
           layer.insertSublayer(selectionLayer, at: 0) // 确保在底层
       }
}

