//
//  TYMicrophonePermission.swift
//  TongyiApp
//
//  Created by Jeremy on 2023/12/4.
//  Copyright © 2023 Aliyun. All rights reserved.
//

import Foundation
import AVFoundation

/// 麦克风权限
class TYPermissionMicrophone: NSObject, TYPermissionInterface {
    
    /// 权限状态
    var status: TYPermissionStatus {
        switch AVCaptureDevice.authorizationStatus(for: .audio) {
        case .notDetermined:
            return .notDetermined
        case .authorized:
            return .authorized
        case .denied, .restricted:
            return .denied
        default:
            return .notDetermined
        }
    }
    
    /// 请求 AVAudioSession 权限
    /// - Parameter сompletionHandler: 请求完成回调
    func request(with сompletionHandler: (() -> ())?) {
        guard let _ = Bundle.main.object(forInfoDictionaryKey: "NSMicrophoneUsageDescription") else {
            debugPrint("TYPermission Warning - NSMicrophoneUsageDescription for \(self.classForCoder) not found in Info.plist")
            return
        }
        AVCaptureDevice.requestAccess(for: .audio) { _ in
            DispatchQueue.main.async {
                сompletionHandler?()
            }
        }
    }
}
