//
//  TYWebController.swift
//  videochat_ios_demo
//
//  Created by wsy on 2025/7/7.
//

import UIKit
import digital_human_ios_sdk
import Network
import SnapKit

class TYWebController : UIViewController {
  
    private var isAlive : Bool = true
    private var mode : TYVoiceChatMode = .tap2talk
    var bottomMarg : Constraint?
    var bgImgV : UIImageView = {
        let bgImg = UIImageView.init()
        bgImg.image = .init(named: "bg_main")
        bgImg.isUserInteractionEnabled = true
        return bgImg
    }()
    
    var titleLab : UILabel = {
        let titleLab = UILabel.init()
        titleLab.font = .boldSystemFont(ofSize: 18)
        titleLab.textAlignment = .center
        titleLab.textColor = .black
        titleLab.text = "iOS交互数字人"
        return titleLab
    }()
    
    var talkSegment : CustomSegmentedControl = {
        let segControl = CustomSegmentedControl.init(items: ["push2talk","tap2talk","双工"])
        segControl.selectedSegmentIndex = 1
        segControl.setEnabled(false, forSegmentAt: 0)
        return segControl
    }()
    
    var cloudSegment : CustomSegmentedControl = {
        let segControl = CustomSegmentedControl.init(items: ["云端渲染","端侧渲染","单独数字人"])
        segControl.selectedSegmentIndex = 0
//        segControl.setEnabled(false, forSegmentAt: 1)
        return segControl
    }()
    
    var aliveSegment : CustomSegmentedControl = {
        let segControl = CustomSegmentedControl.init(items: ["持续心跳保活开启","持续心跳保活关闭"])
        segControl.selectedSegmentIndex = 0
        return segControl
    }()
    
    var textVScrolV : UIScrollView = {
        let scrolV = UIScrollView.init()
        scrolV.backgroundColor = .clear
        scrolV.showsVerticalScrollIndicator = false
        scrolV.showsHorizontalScrollIndicator = false
        scrolV.layer.masksToBounds = true
        scrolV.layer.cornerRadius = 8
//        scrolV.contentSize = CGSizeMake(K_Width - 30, K_Height - 300)
        return scrolV
    }()
    
    var scrolContentView : UIView = {
        let contentView = UIView.init()
        contentView.backgroundColor = .clear
        return contentView
    }()
    
    
    var textV : UITextView = {
        let textView = UITextView.init()
        textView.backgroundColor = .white
        textView.layer.masksToBounds = true
        textView.layer.cornerRadius = 8
        textView.isScrollEnabled = false
        textView.font = .systemFont(ofSize: 14)
        textView.textColor = .black
        return textView
    }()
    
    var placeLab : UILabel = {
        let placeLab = UILabel.init()
        placeLab.textColor = .gray
        placeLab.font = .systemFont(ofSize: 14)
        placeLab.text = "请输入RTC入会信息"
        return placeLab
    }()
    
    var lisenceTextV : UITextView = {
        let lisenTextV = UITextView.init()
        lisenTextV.backgroundColor = .white
        lisenTextV.layer.masksToBounds = true
        lisenTextV.layer.cornerRadius = 8
        lisenTextV.isScrollEnabled = false
        lisenTextV.font = .systemFont(ofSize: 14)
        lisenTextV.textColor = .black
        return lisenTextV
    }()
    
    var lisencePlaceLab : UILabel = {
        let placeLab = UILabel.init()
        placeLab.textColor = .gray
        placeLab.font = .systemFont(ofSize: 14)
        placeLab.text = "请输入lisense"
        return placeLab
    }()
    
    var testBgView : UIView = {
        let bgView = UIView.init()
        bgView.backgroundColor = .clear
        return bgView
    }()
   var testBtn : UIButton = {
        let btn = UIButton()
        btn.layer.masksToBounds = true
        btn.layer.cornerRadius = 8
        btn.setTitle("开始测试", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        return btn
    }()
    private var gradientLayer: CAGradientLayer?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .lightGray
        self.view.addSubview(self.bgImgV)
        self.bgImgV.addSubview(self.titleLab)
        self.bgImgV.addSubview(self.talkSegment)
        self.bgImgV.addSubview(self.cloudSegment)
        self.bgImgV.addSubview(self.aliveSegment)
        self.bgImgV.addSubview(self.textVScrolV)
        self.textVScrolV.addSubview(self.scrolContentView)
        self.textV.delegate = self
        self.lisenceTextV.delegate = self
        self.bgImgV.addSubview(self.testBgView)
        self.testBgView.addSubview(self.testBtn)
        self.textV.addSubview(self.placeLab)
        self.scrolContentView.addSubview(self.textV)
        self.lisenceTextV.addSubview(self.lisencePlaceLab)
        self.scrolContentView.addSubview(self.lisenceTextV)
        
        self.bgImgV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        self.titleLab.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(self.view.safeAreaLayoutGuide.snp.top).inset(25)
            make.height.equalTo(40)
        }
        
        self.talkSegment.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(titleLab.snp.bottom).offset(25)
            make.width.equalTo(250)
            make.height.equalTo(40)
        }
        
        self.cloudSegment.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(talkSegment.snp.bottom).offset(25)
            make.width.equalTo(260)
            make.height.equalTo(40)
        }
        
        self.aliveSegment.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(cloudSegment.snp.bottom).offset(25)
            make.width.equalTo(300)
            make.height.equalTo(40)
        }
        
        self.testBgView.snp.makeConstraints { make in
            make.leftMargin.equalToSuperview()
            make.rightMargin.equalToSuperview()
            make.bottomMargin.equalToSuperview()
            make.height.equalTo(70)
            
        }
        
        self.testBtn.snp.makeConstraints { make in
            make.leftMargin.equalToSuperview().offset(30)
            make.rightMargin.equalToSuperview().offset(-30)
            make.bottomMargin.equalToSuperview().offset(-10)
            make.height.equalTo(50)
        }
        
        self.textVScrolV.snp.makeConstraints { make in
            make.leftMargin.equalToSuperview()
            make.rightMargin.equalToSuperview()
            make.top.equalTo(self.aliveSegment.snp.bottom).offset(25)
            bottomMarg = make.bottomMargin.equalToSuperview().offset(-90).constraint
        }
        
        self.scrolContentView.snp.makeConstraints { make in
            make.edges.equalTo(textVScrolV.contentLayoutGuide)
            make.width.equalTo(textVScrolV.frameLayoutGuide)
        }
        
        self.textV.snp.makeConstraints { make in
            make.top.equalTo(self.scrolContentView.snp.top)
            make.left.equalTo(self.scrolContentView.snp.left).offset(15)
            make.right.equalTo(self.scrolContentView.snp.right).offset(-15)
            make.height.equalTo(textV.contentSize.height > 150 ? textV.contentSize.height : 150)
        }
        self.placeLab.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(10)
            make.top.equalToSuperview().offset(6)
            make.height.equalTo(20)
        }
        
        self.lisenceTextV.snp.makeConstraints { make in
            make.top.equalTo(self.textV.snp.bottom).offset(10)
            make.leftMargin.equalToSuperview().offset(15)
            make.rightMargin.equalToSuperview().offset(-15)
            make.height.equalTo(60)
            make.bottom.equalTo(self.scrolContentView.snp.bottom).offset(-20)
        }
       
        self.lisencePlaceLab.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(10)
            make.top.equalToSuperview().offset(6)
            make.height.equalTo(20)
        }
        
        setupGradient()
        textV.delegate = self
        testBtn.addTarget(self, action:#selector(testBtnAction(sender:)) , for: .touchUpInside)
        aliveSegment.addTarget(self, action: #selector(segmentChanged(_:)), for: .valueChanged)
        talkSegment.addTarget(self, action: #selector(talkModeChanged(_:)), for: .valueChanged)
        let tap = UITapGestureRecognizer(target: self, action: #selector(bgImgTapAction(_:)))
        self.bgImgV.addGestureRecognizer(tap)
        videoChatTestAuthentication()
    }
    
    private func setupGradient() {
           let gradient = CAGradientLayer()
           gradient.colors = [
            UIColor.aly_fromHex(0x49419E).cgColor,
            UIColor.aly_fromHex(0x5E3579).cgColor
           ]
           gradient.startPoint = CGPoint(x: 0, y: 0.5)
           gradient.endPoint = CGPoint(x: 1, y: 0.5)
           gradient.cornerRadius = self.testBtn.layer.cornerRadius
           self.testBtn.layer.insertSublayer(gradient, at: 0)
           self.gradientLayer = gradient
       }
    
    override func viewDidLayoutSubviews() {
            super.viewDidLayoutSubviews()
        gradientLayer?.frame = testBtn.bounds
    }
    
    @objc func segmentChanged(_ sender: UISegmentedControl) {
        let index = sender.selectedSegmentIndex
        self.isAlive = index == 0 ? true : false
    }
    
    @objc func talkModeChanged(_ sender: UISegmentedControl) {
        let index = sender.selectedSegmentIndex
        self.mode = (index == 0) ? .push2talk : (index == 1) ? .tap2talk : .duplex
    }

    
    @objc func bgImgTapAction(_ sender:UITapGestureRecognizer) -> Void {
        if self.textV.isFirstResponder {
            self.textV.resignFirstResponder()
        }
        if self.lisenceTextV.isFirstResponder {
            self.lisenceTextV.resignFirstResponder()
        }
        
        if self.textV.text.isEmpty {
            self.placeLab.isHidden = false
        }else{
            self.placeLab.isHidden = true
        }
        if self.lisenceTextV.text.isEmpty {
            self.lisencePlaceLab.isHidden = false
        }else {
            self.lisencePlaceLab.isHidden = true
        }
        
    }
    //检查网络状态，触发网络权限弹窗
    func videoChatTestAuthentication(){
        let monitor = NWPathMonitor()
        monitor.pathUpdateHandler = { path in
            if path.status == .satisfied {
               
            } else {
               
            }
        }
        monitor.start(queue: DispatchQueue.global())
    }
    
    @objc func testBtnAction(sender: UIButton){
        // RTC入会信息示例, avatarAssets端侧渲染数字人必填，云端渲染数字人可不填
        let rtcInfo = "{\n" +
            "    \"avatarAssets\": {\n" +
            "        \"md5\": \"ACAABCXXXXXXXXCEDCA96A1CC2169848\",\n" +
            "        \"minRequiredVersion\": \"0.0.2\",\n" +
            "        \"secret\": \"XXXXXXX+t7ShPeKPlDUHG6FcGKwpT9LEcovF3oRWEIjWEbL6Dltf20HI/XXXXXXXXX/JAXtZ6ZCOYeHXG1wu6mJ186X2fy7kEz0uXLLCuHrKMBgVprONLTzUaUzasQhaJyZibIrSwP/WVqDq4x5QLmxWpSIf3di+Dc7xo463Ysd2ppazZnMQTgcGRrfgQ1n6YXynzuhMkNF0TR4KP3uQdZRi1oVeXt+R/r3PAw2oHQN6oFZwhOx5KOUCg7a9Wt60mrAQ/Ub9kqlVTmm2wNEM23LTVRIIQ==\",\n" +
            "        \"type\": \"AVATAR_2D_MOBILE\",\n" +
            "        \"url\": \"https://daily-avatar-property.oss-cn-beijing.aliyuncs.com/avatar-share-property/AVATAR_2D_MOBILE/Mt.CQKY55EXBBYU2/secret_assets_android.zip?Expires=1765976701\"\n" +
            "    },\n" +
            "    \"rtcParams\": {\n" +
            "        \"appId\": \"470552b0-9401-4b2c-8456-df39f2e5a986\",\n" +
            "        \"avatarUserId\": \"avatar-8504256390345063\",\n" +
            "        \"channel\": \"8474076537974584\",\n" +
            "        \"clientUserId\": \"client-8677138898148002\",\n" +
            "        \"gslb\": \"https://gw.rtn.aliyuncs.com\",\n" +
            "        \"nonce\": \"\",\n" +
            "        \"serverUserId\": \"system-6956483516401508\",\n" +
            "        \"timestamp\": 1766059500,\n" +
            "        \"token\": \"4857c6f7b127a11dbf122a68ac48a1637f9693c3d0d5fd4bf91c39a2c73ed882\"\n" +
            "    },\n" +
            "    \"sessionId\": \"E89428D7-FD74-487A-A7B3-0EFF3A0AA43C\"\n" +
            "}";
        // textV.text = rtcInfo
        
        // License示例
        let license = "941ea11378a5cc9b94abfeb06f255ab8adedbcxxxxxxxxxxxxxxxx"
        // lisenceTextV.text = license

        let result = checkError()
        
        if result.0 == true {
            let jsonStr = textV.text
            guard let data = jsonStr?.data(using: .utf8) else {
                ALYToast.shared.showToast(text:"鉴权字段有误，请修正后重新加入", style: .error)
                return
            }
            
            if let resp = try? JSONSerialization.jsonObject(with: data, options: .fragmentsAllowed) as? [String: Any] {
                let renderType = self.cloudSegment.selectedSegmentIndex == 0 ? TYAvatarType.cloud : self.cloudSegment.selectedSegmentIndex == 1 ? TYAvatarType.local : TYAvatarType.avatar_only
                let params = TYDialogConfig(renderType: renderType, mode: self.mode, keepAlive: self.isAlive, keepAlivePeriod: 10, avatarAudioFormat: "s16", outboundSampleRate: renderType == .avatar_only ? 16000 : 48000, avatarBlendShapeScale: 1.5)
                
                // 校验RTC参数
                guard
                    let rtcParams = resp["rtcParams"] as? [String: Any],
                    let avatarUserId = rtcParams["avatarUserId"] as? String,
                    let appId = rtcParams["appId"] as? String,
                    let channel = rtcParams["channel"] as? String,
                    let clientUserId = rtcParams["clientUserId"] as? String,
                    let timestamp = rtcParams["timestamp"] as? Int64,
                    let token = rtcParams["token"] as? String,
                    let serverUserId = rtcParams["serverUserId"] as? String
                else {
                    print("[RTC] param error")
                    ALYToast.shared.showToast(text: "RTC params illegal", style: .error)
                    return
                }
                
                // 端渲染需要额外校验资产参数
                var assetConfig: TYAvatarAssetConfig? = nil
                if renderType != .cloud {
                    guard
                        let assertParms = resp["avatarAssets"] as? [String : String],
                        let url = assertParms["url"],
                        let md5 = assertParms["md5"],
                        let secret = assertParms["secret"]
                    else {
                        ALYToast.shared.showToast(text: "avatarAssets config illegal", style: .error)
                        print("avatarAssets config illegal")
                        return
                    }
                    
                    assetConfig = TYAvatarAssetConfig.init(url: url, md5: md5, secret: secret)
                }
                
                let tempStr = resp["requestId"] as? String
                var requestId : String?
                if tempStr == nil {
                    requestId = "testUserId_\(Date().timeIntervalSince1970)"
                }else{
                    requestId = tempStr
                }
                let avatarInitConfig = TYAvatarInitConfig.init(appId: appId, channel: channel, timestamp: timestamp, token: token, clientUserId: clientUserId, serverUserId: serverUserId, avatarUserId: avatarUserId)

                let avatarInitData = TYAvatarInitData(rtcParams: avatarInitConfig, avatarAssets: assetConfig, requestId:requestId, success: true, httpStatusCode: 0)
                
                DispatchQueue.main.async {
                    let vc = VideoChatViewController(license:self.lisenceTextV.text ?? "" , avatarInitData: avatarInitData, dialogConfig: params)
                    self.navigationController?.pushViewController(vc, animated: true)
                }
            }else{
                ALYToast.shared.showToast(text:"鉴权字段无法解析，请修正后重新加入", style: .error)
                return
            }
        }else {
            ALYToast.shared.showToast(text:result.1, style: .error)
            return
        }
    }
    
    func checkError() -> (Bool,String) {
        
        if self.cloudSegment.selectedSegmentIndex == 0 {//云端渲染
            if self.textV.text.isEmpty {
                self.placeLab.isHidden = false
                return (false,"RTC入会信息不能为空")
            }
            self.placeLab.isHidden = true
            return (true,"")
        }else {//端渲染
            if self.textV.text.isEmpty {
                self.placeLab.isHidden = false
                return (false,"RTC入会信息不能为空")
            }
            if self.lisenceTextV.text.isEmpty {
                return (false,"lisence信息不能为空")
            }
            self.placeLab.isHidden = true
            return (true,"")
        }
    }
}


extension TYWebController : UITextViewDelegate {
    
    func textViewDidChange(_ textView: UITextView) {
      
        if self.textV.text.isEmpty {
            self.placeLab.isHidden = false
        }else{
            self.placeLab.isHidden = true
        }
        
        if lisenceTextV.text.isEmpty {
            self.lisencePlaceLab.isHidden = false
        }else {
            self.lisencePlaceLab.isHidden = true
        }
        
        if textView == self.textV {
            let fixedWidth = textView.frame.width
            let newSize = textView.sizeThatFits(CGSize(width: fixedWidth, height: .greatestFiniteMagnitude))
            self.textV.snp.updateConstraints { make in
                make.height.equalTo(newSize.height > 150 ? newSize.height : 150)
            }
        }
    }
    
    func textViewDidBeginEditing(_ textView: UITextView) {
        if textView == self.textV {
            self.placeLab.isHidden = true
        }
        
        if textView == self.lisenceTextV {
            self.lisencePlaceLab.isHidden = true
        }
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
        if self.textV.text.isEmpty {
            self.placeLab.isHidden = false
        }else{
            self.placeLab.isHidden = true
        }
        
        if lisenceTextV.text.isEmpty {
            self.lisencePlaceLab.isHidden = false
        }else {
            self.lisencePlaceLab.isHidden = true
        }
    }
}

