//
//  UIWindow+ALYExt.swift
//  ALYUIKit
//
//  Created by 济凡(范伟) on 2022/1/25.
//  Copyright © 2022 Aliyun. All rights reserved.
//

import UIKit

extension UIWindow {
    
    /// 获取当前显示的window，同UIApplication的keyWindow
    public class var aly_currentWindow: UIWindow? {
        if #available(iOS 13.0, *) {
//            let window = UIApplication.shared.connectedScenes
//                .filter({ $0.activationState == .foregroundActive })
//                .compactMap({ $0 as? UIWindowScene })
//                .first?.windows
//                .filter({ $0.isKeyWindow }).first
            let window = UIApplication.shared.windows.first(where: \.isKeyWindow)
            return window
        } else {
            return UIApplication.shared.keyWindow
        }
    }
    
    /// 获取AppDelegate的Window
    public class var aly_appWindow: UIWindow? {
        if let appDelegate = UIApplication.shared.delegate,
           let window = appDelegate.window
        {
            return window
        }
        return nil
    }
    
}

public func aly_topmostViewController() -> UIViewController? {
    var topViewController: UIViewController? = UIApplication.shared.keyWindow?.rootViewController
    while true {
        if let presentedVC = topViewController?.presentedViewController {
            topViewController = topViewController?.presentedViewController
        } else if let nav = topViewController as? UINavigationController {
            topViewController = nav.topViewController
        } else if let tab = topViewController as? UITabBarController {
            topViewController = tab.selectedViewController
        } else {
            break
        }
    }
    return topViewController
}
