//
//  URL+ALYExt.swift
//  ALYFoundation
//
//  Created by Wien on 2023/9/7.
//  Copyright © 2023 Aliyun. All rights reserved.
//

import Foundation

extension URL {
    
    public func aly_getURLParams() -> [String : String]? {
        if self.absoluteString.count == 0 {
            return nil
        }
        
        if let paramDict = self.query?.components(separatedBy: "&").map({ (query) -> (String, String)? in
            
            let arr = query.components(separatedBy: "=")
            if arr.count == 2 {
                return (arr[0], arr[1])
            }
            return nil
        }).reduce([String: String](), { (result: [String: String], pair) -> [String: String] in
            
            var result = result
            if let p = pair {
                result[p.0] = p.1
            }
            return result
        }) {
            return paramDict
        }
        
        return nil
    }
    
    public func aly_path(percentEncoded: Bool = true) -> String {
        var result: String
        if #available(iOS 16.0, *) {
            result = self.path(percentEncoded: percentEncoded)
        } else {
            result = self.path
        }
        return result
    }
    
}


let kDomainWhiteList = ".cctv.com#.modelscope.cn#.aliyun.com#.alibabacloud.com#.qutao.com#.huiyibaba.com#.aliyun.net#.render.fj.bnet.cn#.csdn.net#.kpp.k-touch.cn#.t-nds.k-touch.cn#.phpwind.com#.phpwind.net#.www.net.cn#.hichina.com#.yunos.com#.amap.com#.umeng.com#.jiagouyun.com#.oschina.net#.wenjuan.com#.gein.cn#.aliyunvpc.com#.no-ip.org#.tgtact.com#.cnzz.com#.domob-inc.cn#.alibench.com#.taobao.com#.domob.cn#.aliyunedu.net#.aliapp.com#.dingtalk.com#.weibo.com#.toohappy.cn#.aliyunstarts.com#.yushanfang.com#.aliyun-inc.com#.qupai.me#.tmall.com#.alipay.com#.alibaba-inc.com#.1688.com#.gein.cn#.alibaba.com#.taobao.net#.alicdn.com#.tb.cn#.youku.com"

/// 路由白名单等逻辑判断
extension URL {
    
    /// 是否属于自有域名，目前只有两个 aliyun.com 和 taobao.com
    public func aly_isInOwnDomain() -> Bool {
        let allowdDomains = [
            "aliyun.com",
            "taobao.com",
            "xe8.cn",
            "lxblog.com"
        ]
        return self.aly_isInDomains(allowdDomains)
    }
    
    /// 检测当前URL是否属于domains范围内的链接
    public func aly_isInDomains(_ domains: [String]) -> Bool {
        guard let host = self.host else {
            return false
        }

        let allowdDomains = domains
        var result = false
        if allowdDomains.contains(where: { host.hasSuffix($0) }) {
            result = true
        }
        return result
    }
    
    /// 是否在域名白名单内
    public func aly_isInDomainWhiteList() -> Bool {
        // 自有域名也属于域名白名单
        if self.aly_isInOwnDomain() {
            return true
        }
        
        if var list = self.host?.components(separatedBy: ".") {
            let url = list.joined(separator: ".")
            // 去掉www这样的前缀
            list.removeFirst()
            
            let whiteUrlList = kDomainWhiteList.components(separatedBy: "#")
            for whiteUrl in whiteUrlList {
                if ".\(url)".hasSuffix(whiteUrl.trimmingCharacters(in: CharacterSet(charactersIn: " "))) {
                    return true
                }
            }
        }
        return false
    }

    public dynamic func isUrlInBlackList() -> Bool {

//        if let fullMatchBlackListString = Orange.getConfigByGroupName("app_web_config", key: "full_match_black_list", defaultConfig: nil, isDefault: nil) as? String {
//
//            let blackUrlList = fullMatchBlackListString.components(separatedBy: "#")
//            for blackUrl in blackUrlList {
//                var urlComponents = URLComponents(string: self.absoluteString)
//                urlComponents?.queryItems = nil
//                if let url = urlComponents?.url?.absoluteString {
//                    if url == blackUrl.trimmingCharacters(in: CharacterSet(charactersIn: " ")) {
//                        return true
//                    }
//                }
//            }
//        }
//
//        //每次都读取并切分，是为了保证会立即生效。
//        if let blackListString = Orange.getConfigByGroupName("app_web_config", key: "black_list", defaultConfig: nil, isDefault: nil) as? String {
//
//            let blackUrlList = blackListString.components(separatedBy: "#")
//            for blackUrl in blackUrlList {
//                if self.absoluteString.contains(blackUrl.trimmingCharacters(in: CharacterSet(charactersIn: " "))) {
//                    return true
//                }
//            }
//        }

        return false
    }
    
    /// 判断当前url是否在禁用名单里。
    ///
    /// - 在这个名单里的链接，命中后会提示无法打开
    /// - url格式如下：facebook.com、facebook.com/login等
    public func isUrlInBanList() -> Bool {
//        var components = URLComponents(string: self.absoluteString)
//        components?.queryItems = nil
//        let urlStr = components?.url?.absoluteString
//        guard let urlStr = urlStr else {
//            return false
//        }
//
//        guard let urlList = ALYViper.getConfig(namespace: "app_url_ban_list", key: nil) as? [String] else {
//            return false
//        }
//
//        for url in urlList {
//            if urlStr.contains(url.trimmingCharacters(in: CharacterSet(charactersIn: " "))) {
//                return true
//            }
//        }
        
        return false
    }
    
}
